function rgb = nhkInter( bayer, cfaPattern )
%Bilinear demosaic algorithm 
%
%    rgb = Bilinear( bayer, cfaPattern )
%
% Demosaic'ing algorithms estimate missing color information by
% interpolation of the known color information across different color
% planes.  
%
% This routine implements a bilinear algorithm
%
% Copyright ImagEval Consultants, LLC, 2005.


% TODO:  Should check arguments, update programming style
%

[r,c,nPlanes] = size(bayer);

% There are three basic configurations for a color sensor in a 2x2 block.
% The sensor can occupy a single location, a pair of locations in a common row/col,
% or a pair of locations in diagonal positions.  We use the appropriate
% linear interpolation kernel in each of these cases.

for ii=1:nPlanes
    thisPlane = bayer(:,:,ii);
    l = (cfaPattern == ii);
     if ( l(1) == 1 & l(4) == 1) | (l(2) == 1 & l(3) == 1)   
        disp('nhkInter_G')
        % Opposite coner positions
        rgb(:,:,ii) = conv2(thisPlane, [0 0 0; 0 1/4 0; 1/4 1 1/4; 0 1/4 0; 0 0 0], 'valid');        
    else  
        disp('nhkInter_BR')
        % Otherwise
        thisPlane   = conv2(thisPlane, [0 1 0] , 'valid');
        rgb(:,:,ii) = conv2(thisPlane, [1 1 1 1]', 'valid');
    end
end

return;

% figure; imagesc(thisPlane); colormap(gray)
% figure; imagesc(rgb(:,:,ii)); colormap(gray)